<?php

namespace App\Http\Controllers;

use App\Http\Requests\CategoriesRequest;
use App\Http\Requests\ImagesRequest;
use App\Models\Category;
use App\Models\Service;

class CategoriesController extends Controller
{
    private string $path = 'images/categories/';

    public function __construct()
    {
        $this->middleware('jwt');
        $this->middleware('userStatus');
        $this->middleware('blocked');
    }

    public function getAll(): \Illuminate\Http\JsonResponse
    {
        $categories = Category::all();
        return response()->json([
            'success' => true,
            'data' => $categories,
        ], 200);
    }

    public function add(CategoriesRequest $request): \Illuminate\Http\JsonResponse
    {
        if (auth()->user()->can_add_edit_delete_categories) {

            $category = new Category($request->validated());
            if ($category->save()) {
                return response()->json([
                    'success' => true,
                    'data' => $category,
                ], 200);
            } else {
                return response()->json([
                    'success' => false,
                    'message' => 'error add category info!',
                ], 422);
            }

        } else {
            return response()->json([
                'success' => false,
                'message' => 'you do not have permission to do this!'
            ], 422);
        }
    }

    public function setImage(ImagesRequest $request, $id): \Illuminate\Http\JsonResponse
    {
        if (auth()->user()->can_add_edit_delete_categories) {

            $category = Category::find($id);

            if (isset($category->img_path)) {
                unlink($category->img_path);
            }

            $imgName = time() . '.' . $request->img_path->getClientOriginalExtension();
            $request->file('img_path')->move($this->path, $imgName);
            $category['img_path'] = $this->path . $imgName;

            if ($category->save()) {
                return response()->json([
                    'success' => true,
                    'data' => $category
                ], 200);
            } else {
                return response()->json([
                    'success' => false,
                    'message' => 'error saving category image',
                ], 422);
            }

        } else {
            return response()->json([
                'success' => false,
                'message' => 'you do not have permission to do this!'
            ], 422);
        }
    }

    public function edit(CategoriesRequest $request, $id): \Illuminate\Http\JsonResponse
    {
        if (auth()->user()->can_add_edit_delete_categories) {

            $category = Category::find($id);
            if ($category != null) {
                $category->name = $request->name;
                if ($category->save()) {
                    return response()->json([
                        'success' => true,
                        'data' => $category,
                    ], 200);
                } else {
                    return response()->json([
                        'success' => false,
                        'message' => 'error edit category info!',
                    ], 422);
                }
            } else {
                return response()->json([
                    'success' => false,
                    'message' => 'category not found!',
                ], 422);
            }

        } else {
            return response()->json([
                'success' => false,
                'message' => 'you do not have permission to do this!'
            ], 422);
        }
    }

    public function delete($id): \Illuminate\Http\JsonResponse
    {
        if (auth()->user()->can_add_edit_delete_categories) {

            $category = Category::find($id);

            if ($category != null) {
                $hasServices = Service::where('category_id', $id)->exists();
                if ($hasServices) {
                    return response()->json([
                        'success' => false,
                        'message' => 'can not delete category has services!',
                    ], 422);
                } else {
                    if ($category->delete()) {
                        return response()->json([
                            'success' => true,
                        ], 200);
                    } else {
                        return response()->json([
                            'success' => false,
                            'message' => 'error delete category info!',
                        ], 422);
                    }
                }
            } else {
                return response()->json([
                    'success' => false,
                    'message' => 'category not found!',
                ], 422);
            }

        } else {
            return response()->json([
                'success' => false,
                'message' => 'you do not have permission to do this!'
            ], 422);
        }
    }

}
