<?php

namespace App\Http\Controllers;

use App\Enums\UserTypes;
use App\Http\Requests\AddBalanceForAdminRequest;
use App\Http\Requests\ImagesRequest;
use App\Http\Requests\UserInfoRequest;
use App\Http\Requests\UserPermissionsRequest;
use App\Models\User;


class UsersController extends Controller
{
    private string $path = 'images/users/';

    public function __construct()
    {
        $this->middleware('jwt');
        $this->middleware('userStatus');
        $this->middleware('blocked');
    }

    public function editUserInfo(UserInfoRequest $request, $id): \Illuminate\Http\JsonResponse
    {
        $user = User::find($id);
        if ($user != null) {

            $user->name = $request->name;
            $user->address = $request->address;
            $user->notes = $request->notes;

            if ($user->save()) {
                return response()->json([
                    'success' => true,
                    'data' => $user
                ], 200);
            } else {
                return response()->json([
                    'success' => false,
                    'message' => 'error saving user info',
                ], 422);
            }

        } else {
            return response()->json([
                'success' => false,
                'message' => 'user not found!'
            ], 422);
        }


    }

    public function editUserPermissions(UserPermissionsRequest $request, $id): \Illuminate\Http\JsonResponse
    {
        if (auth()->user()->can_edit_users) {

            $user = User::find($id);
            if ($user != null) {

                $user->user_type = $request->user_type;
                $user->can_charge_balance = $request->can_charge_balance;
                $user->can_edit_users = $request->can_edit_users;
                $user->can_delete_users = $request->can_delete_users;
                $user->can_add_service = $request->can_add_service;
                $user->can_edit_service = $request->can_edit_service;
                $user->can_delete_service = $request->can_delete_service;
                $user->can_edit_orders = $request->can_edit_orders;
                $user->can_accept_auto_orders = $request->can_accept_auto_orders;
                $user->can_add_edit_delete_categories = $request->can_add_edit_delete_categories;
                $user->can_see_statistics = $request->can_see_statistics;
                $user->can_charge_balance_for_admin = $request->can_charge_balance_for_admin;
                $user->user_state = $request->user_state;

                if ($user->save()) {
                    return response()->json([
                        'success' => true,
                        'data' => $user
                    ], 200);
                } else {
                    return response()->json([
                        'success' => false,
                        'message' => 'error saving user permissions',
                    ], 422);
                }

            } else {
                return response()->json([
                    'success' => false,
                    'message' => 'user not found!'
                ], 422);
            }

        } else {
            return response()->json([
                'success' => false,
                'message' => 'you do not have permission to do this!'
            ], 422);
        }
    }

    public function setImage(ImagesRequest $request, $id)
    {
        $user = User::find($id);
        if ($request->file('img_path')) {

            if (isset($user->img_path)) {
                unlink($user->img_path);
            }

            $imgName = time() . '.' . $request->img_path->getClientOriginalExtension();
            $request->file('img_path')->move($this->path, $imgName);
            $user['img_path'] = $this->path . $imgName;

            if ($user->save()) {
                return response()->json([
                    'success' => true,
                    'data' => $user
                ], 200);
            } else {
                return response()->json([
                    'success' => false,
                    'message' => 'error saving user image',
                ], 422);
            }

        }
    }

    public function getAll(): \Illuminate\Http\JsonResponse
    {
        $users = User::all();

        foreach ($users as $user) {
            $user->balance = OrdersController::getUserBalance($user->id);
        }

        return response()->json([
            'success' => true,
            'data' => $users
        ], 200);
    }

    public function getAllAdmins(): \Illuminate\Http\JsonResponse
    {
        $admins = User::where('user_type', UserTypes::$admin)->get();

        return response()->json([
            'success' => true,
            'data' => $admins,
        ], 200);
    }

    public function addBalanceForAdmin(AddBalanceForAdminRequest $request): \Illuminate\Http\JsonResponse
    {
        if (auth()->user()->can_charge_balance_for_admin) {

            $user = User::find($request->admin_id);
            if ($user != null) {
                $user->balance_to_charge = $user->balance_to_charge + $request->balance;
                if ($user->save()) {
                    return response()->json([
                        'success' => true,
                        'data' => $user,
                    ], 200);
                } else {
                    return response()->json([
                        'success' => false,
                        'message' => 'error update admin balance!',
                    ], 422);
                }
            } else {
                return response()->json([
                    'success' => false,
                    'message' => 'user not found!',
                ], 422);
            }
        } else {
            return response()->json([
                'success' => false,
                'message' => 'you do not have permission to do this!'
            ], 422);
        }
    }
}
