<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class CheckBlockedStatus
{
    /**
     * Handle an incoming request.
     *
     * @param Request $request
     * @param Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\JsonResponse
     */
    public function handle(Request $request, Closure $next): \Illuminate\Http\JsonResponse
    {
        $user = $request->user();

        if ($user && $user->blocked_until && now()->lt($user->blocked_until)) {
            return response()->json([
                'success' => false,
                'message' => 'Your account is blocked. Please try again later.'
            ], 403);
        }

        return $next($request);
    }
}
