<?php

namespace App\Http\Middleware;

use App\Enums\UserStates;
use Closure;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class UserStatusMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param Request $request
     * @param Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return JsonResponse
     */
    public function handle(Request $request, Closure $next): JsonResponse
    {
        if (auth()->user()->user_state != UserStates::$active) {
            return response()->json([
                'success' => false,
                'message' => 'your account is disable',
            ], 401);
        }
        return $next($request);
    }
}
