<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AddBalanceForAdminRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(): array
    {
        return [
            'admin_id' => 'required|int',
            'balance' => 'required|numeric'
        ];
    }

    public function messages(): array
    {
        return [
            'admin_id.required' => '11',
            'admin_id.numeric' => '31',
            'balance.required' => '11',
            'balance.numeric' => '31',
        ];
    }
}
