<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ChangeOrderState extends FormRequest
{

    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'order_status' => 'required|int',
            'rejection_note' => 'requiredIf:order_status,2',
        ];
    }

    public function messages(): array
    {
        return [
            'order_status.required' => '11',
            'order_status.int' => '31',
            'rejection_note.required' => '11'
        ];
    }
}
