<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ChargeBalanceRequest extends FormRequest
{

    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'user_id' => 'required|int',
            'total' => 'required|numeric',
            'order_status' => 'required|int',
        ];
    }

    public function messages(): array
    {
        return [
            'user_id.required' => '11',
            'user_id.int' => '31',
            'total.required' => '11',
            'total.numeric' => '31',
            'order_status.required' => '11',
            'order_status.int' => '31',
        ];
    }
}
