<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class FilterOrderRequest extends FormRequest
{

    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'start_date' => 'required|string',
            'end_date' => 'required|string',
            'user_id' => 'nullable|int',
            'service_id' => 'nullable|int',
        ];
    }

    public function messages(): array
    {
        return [
            'start_date.required' => '11',
            'start_date.string' => '21',
            'end_date.required' => '11',
            'end_date.string' => '21',
            'user_id.int' => '31',
            'service_id.int' => '31',
        ];
    }
}
