<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ImagesRequest extends FormRequest
{

    public function authorize(): bool
    {
        return true;
    }


    public function rules(): array
    {
        return [
            'img_path' => 'required|image|mimes:jpg,png,jpeg,gif,svg|max:2048'
        ];
    }

    public function messages(): array
    {
        return [
            'img_path.required' => '11',
            'img_path.image' => '15',
            'img_path.mimes' => '15',
            'img_path.max' => '23',
        ];
    }
}
