<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class OrdersRequest extends FormRequest
{

    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'service_id' => 'required|int',
            'price' => 'numeric|required',
            'tax_percent' => 'numeric|required',
            'total' => 'numeric|required',
            'account_number' => 'required|string',
            'account_number_2' => 'nullable|string',
            'user_id' => 'required|int',
            'notes' => 'nullable|max:2000',
            'image' => 'nullable|image|mimes:jpg,png,jpeg,gif,svg|max:2048'
        ];
    }

    public function messages(): array
    {
        return [
            'service_id.required' => '11',
            'service_id.int' => '31',
            'price.required' => '11',
            'price.numeric' => '31',
            'tax_percent.required' => '11',
            'tax_percent.numeric' => '31',
            'total.required' => '11',
            'total.numeric' => '31',
            'account_number.required' => '11',
            'account_number.string' => '21',
            'account_number_2.string' => '21',
            'user_id.required' => '11',
            'user_id.int' => '31',
            'notes.max' => '23',
            'image.image' => '15',
            'image.mimes' => '15',
            'image.max' => '23',
        ];
    }
}
