<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ServiceEditRequest extends FormRequest
{

    public function authorize(): bool
    {
        return true;
    }


    public function rules(): array
    {
        return [
            'name' => 'required|string',
            'description' => 'nullable|max:4000',
            'notes' => 'nullable|max:4000',
            'cost' => 'requiredIf:type,1',
            'tax_percent' => 'requiredIf:type,1',
            'service_code' => 'nullable|max:255',
            'is_active' => 'bool',
            'sim_id' => 'nullable|int',
            'admin_id' => 'nullable|int',
            'category_id' => 'requiredIf:type,0|int',
            'has_second_account_number_2' => 'required|bool',
        ];
    }

    public function messages(): array
    {
        return [
            'name.required' => '11',
            'name.string' => '21',
            'description.max' => '23',
            'notes.max' => '23',
            'cost.required' => '11',
            'tax_percent.required' => '11',
            'service_code.max' => '23',
            'is_active.bool' => '41',
            'sim_id.int' => '31',
            'admin_id.int' => '31',
            'category_id.int' => '31',
            'category_id.required' => '11',
            'has_second_account_number_2.required' => '11',
            'has_second_account_number_2.bool' => '41',
        ];
    }

}
