<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ServicesRequest extends FormRequest
{

    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'name' => 'required|string',
            'description' => 'nullable|max:2000',
            'notes' => 'nullable|max:200',
            'type' => 'required|int',
            'parent_id' => 'nullable|requiredIf:type,1|int',
            'cost' => 'requiredIf:type,1|numeric',
            'tax_percent' => 'requiredIf:type,1|numeric',
            'service_code' => 'nullable|max:255',
            'sim_id' => 'nullable|int',
            'admin_id' => 'nullable|int',
            'category_id' => 'requiredIf:type,0|int',
            'has_second_account_number_2' => 'required|bool',
            'has_image' => 'required|bool',
        ];
    }

    public function messages(): array
    {
        return [
            'name.required' => '11',
            'name.string' => '21',
            'description.max' => '23',
            'notes.max' => '23',
            'type.required' => '11',
            'type.int' => '31',
            'parent_id.required' => '11',
            'cost.required' => '11',
            'cost.numeric' => '31',
            'tax_percent.required' => '11',
            'tax_percent.numeric' => '31',
            'service_code.max' => '23',
            'sim_id.int' => '31',
            'admin_id.int' => '31',
            'category_id.required' => '11',
            'category_id.int' => '31',
            'has_second_account_number_2.required' => '11',
            'has_second_account_number_2.bool' => '41',
            'has_image.required' => '11',
            'has_image.bool' => '41',
        ];
    }


}
