<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UserInfoRequest extends FormRequest
{

    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'name' => 'required|string|max:50',
            'address' => 'nullable|max:1000',
            'notes' => 'nullable|max:2000',
        ];
    }

    public function messages(): array
    {
        return [
            'name.required' => '11',
            'name.string' => '21',
            'name.max' => '23',
            'address.max' => '23',
            'notes.max' => '23',
        ];
    }
}
