<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UserPermissionsRequest extends FormRequest
{

    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'user_type' => 'required|int',
            'can_charge_balance' => 'required|bool',
            'can_edit_users' => 'required|bool',
            'can_delete_users' => 'required|bool',
            'can_add_service' => 'required|bool',
            'can_edit_service' => 'required|bool',
            'can_delete_service' => 'required|bool',
            'can_edit_orders' => 'required|bool',
            'can_accept_auto_orders' => 'required|bool',
            'can_add_edit_delete_categories' => 'required|bool',
            'can_see_statistics' => 'required|bool',
            'can_charge_balance_for_admin' => 'required|bool',
            'user_state' => 'required|int',
        ];
    }

    public function messages(): array
    {
        return [
            'user_type.required' => '11',
            'user_type.int' => '31',
            'can_charge_balance.required' => '11',
            'can_charge_balance.bool' => '41',
            'can_edit_users.required' => '11',
            'can_edit_users.bool' => '41',
            'can_delete_users.required' => '11',
            'can_delete_users.bool' => '41',
            'can_add_service.required' => '11',
            'can_add_service.bool' => '41',
            'can_edit_service.required' => '11',
            'can_edit_service.bool' => '41',
            'can_delete_service.required' => '11',
            'can_delete_service.bool' => '41',
            'can_edit_orders.required' => '11',
            'can_edit_orders.bool' => '41',
            'can_accept_auto_orders.required' => '11',
            'can_accept_auto_orders.bool' => '41',
            'can_add_edit_delete_categories.required' => '11',
            'can_add_edit_delete_categories.bool' => '41',
            'can_see_statistics.required' => '11',
            'can_see_statistics.bool' => '41',
            'can_charge_balance_for_admin.required' => '11',
            'can_charge_balance_for_admin.bool' => '41',
            'user_state.required' => '11',
            'user_state.int' => '31',
        ];
    }
}
