<?php

namespace App\Models;

use App\Http\Controllers\OrdersController;
use Illuminate\Database\Eloquent\Model;

/**
 * @property mixed $service_id
 * @method static where(array[] $array)
 * @method static orderBy(string $string)
 * @method static find($id)
 * @method static whereBetween(string $string, array $array)
 */
class Order extends Model
{
    protected $appends = ['service_code', 'sim_id', 'admin_id', 'service_name', 'user_name', 'admin_name', 'user_balance'];

    protected $fillable = [
        'id',
        'service_id',
        'price',
        'tax_percent',
        'total',
        'user_id',
        'notes',
        'order_status',
        'account_number',
        'account_number_2',
        'rejection_note',
        'created_at',
        'admin_id_for_statistics',
        'image'
    ];


    public function service(): \Illuminate\Database\Eloquent\Relations\BelongsTo
    {
        return $this->belongsTo(Service::class, 'service_id');
    }

    public function user(): \Illuminate\Database\Eloquent\Relations\belongsTo
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function admin(): \Illuminate\Database\Eloquent\Relations\belongsTo
    {
        return $this->belongsTo(User::class, 'admin_id_for_statistics');
    }

    public function getServiceNameAttribute()
    {
        if ($this->service_id != null) {
            return $this->service()->first()->name;
        } else {
            return null;
        }
    }

    public function getUserBalanceAttribute()
    {
        return OrdersController::getUserBalance($this->user_id);
    }

    public function getUserNameAttribute()
    {
        return $this->user()->first()->name;
    }

    public function getAdminNameAttribute()
    {
        if ($this->admin_id_for_statistics != null) {
            return $this->admin()->first()->name;
        } else {
            return null;
        }
    }

    public function getServiceCodeAttribute()
    {
        if ($this->service_id != null) {
            if ($this->service()->first()->parent_id != null) {
                $parentServices = Service::where('id', $this->service()->first()->parent_id)->first();
                return $parentServices['service_code'];
            } else {
                return $this->service()->first()->service_code;
            }
        }
    }


    public function getSimIdAttribute()
    {
        if ($this->service_id != null) {
            if ($this->service()->first()->parent_id != null) {
                $parentServices = Service::where('id', $this->service()->first()->parent_id)->first();
                return $parentServices['sim_id'];
            } else {
                return $this->service()->first()->sim_id;
            }
        }
    }

    public function getAdminIdAttribute()
    {
        if ($this->service_id != null) {
            if ($this->service()->first()->parent_id != null) {
                $parentServices = Service::where('id', $this->service()->first()->parent_id)->first();
                return $parentServices['admin_id'];
            } else {
                return $this->service()->first()->admin_id;
            }
        }
    }

}
