<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;


/**
 * @method static where(string $string, \Illuminate\Database\Eloquent\HigherOrderBuilderProxy|mixed $parent_id)
 * @method static find($id)
 * @property mixed $parent_id
 */
class Service extends Model
{

    protected $fillable = [
        'id',
        'name',
        'description',
        'img_path',
        'notes',
        'parent_id',
        'type',
        'cost',
        'tax_percent',
        'service_code',
        'sim_id',
        'admin_id',
        'category_id',
        'has_second_account_number_2',
        'has_image'
    ];

    public function orders(): \Illuminate\Database\Eloquent\Relations\BelongsTo
    {
        return $this->belongsTo(Order::class, 'service_id');
    }

}
