<?php

namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Laravel\Sanctum\HasApiTokens;
use Tymon\JWTAuth\Contracts\JWTSubject;

/**
 * @method static find($id)
 * @method static where(string $string, int $admin)
 * @method static create(array|string[] $array_merge)
 */
class User extends Authenticatable implements JWTSubject
{
    use HasApiTokens;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'phone',
        'password',
        'balance_to_charge',
        'address',
        'notes',
        'img_path',
        'user_type',
        'user_state',
        'blocked_until',
        'can_charge_balance',
        'can_edit_users',
        'can_delete_users',
        'can_add_service',
        'can_edit_service',
        'can_delete_service',
        'can_edit_orders',
        'can_accept_auto_orders',
        'can_add_edit_delete_categories',
        'can_see_statistics',
        'can_charge_balance_for_admin',
    ];

    protected $hidden = [
        'password',
    ];

    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    public function getJWTCustomClaims(): array
    {
        return [];
    }

    public function orders(): \Illuminate\Database\Eloquent\Relations\HasMany
    {
        return $this->hasMany(Order::class, 'user_id');
    }

}
